<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pastikan path ke koneksi.php benar
$root_path = $_SERVER['DOCUMENT_ROOT'];
require_once($root_path . '/config/koneksi.php');

session_start();

// Tambahkan log untuk debugging
function tulis_log($pesan) {
    $file_log = __DIR__ . '/debug_form.log';
    $waktu = date('Y-m-d H:i:s');
    file_put_contents($file_log, "[$waktu] $pesan\n", FILE_APPEND);
}

if(isset($_POST['submit'])) {
    tulis_log("Form dikirim dengan data: " . print_r($_POST, true));
    
    try {
        // Validasi input
        if(empty($_POST['user']) || empty($_POST['pass']) || empty($_POST['full_name']) || 
           empty($_POST['email']) || empty($_POST['no_hp']) || empty($_POST['level'])) {
            throw new Exception("Semua field harus diisi");
        }

        // Sanitasi input
        $username = mysqli_real_escape_string($conn, $_POST['user']);
        $password = password_hash($_POST['pass'], PASSWORD_DEFAULT);
        $full_name = mysqli_real_escape_string($conn, $_POST['full_name']);
        $email = mysqli_real_escape_string($conn, $_POST['email']);
        $phone = mysqli_real_escape_string($conn, $_POST['no_hp']);
        $level = mysqli_real_escape_string($conn, $_POST['level']);
        
        // Cek username atau email yang sudah ada
        $check_query = mysqli_query($conn, "SELECT * FROM admin WHERE user = '$username' OR email = '$email'");
        if(mysqli_num_rows($check_query) > 0) {
            tulis_log("Username atau email sudah terdaftar");
            header("Location: ../user/index.php?notif=2");
            exit();
        }
        
        // Generate token
        $token = bin2hex(random_bytes(32));
        
        // Ubah query INSERT
        $query = "INSERT INTO admin (user, pass, full_name, email, no_hp, level, token_id, status) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, 1)";
        
        $stmt = mysqli_prepare($conn, $query);
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "sssssss", $username, $password, $full_name, $email, $phone, $level, $token);
            
            if(mysqli_stmt_execute($stmt)) {
                tulis_log("Berhasil menambahkan user baru: $username");
                header("Location: ../user/index.php?notif=1");
                exit();
            } else {
                throw new Exception("Error database: " . mysqli_stmt_error($stmt));
            }
        } else {
            throw new Exception("Error dalam persiapan statement: " . mysqli_error($conn));
        }
        
    } catch (Exception $e) {
        tulis_log("Error: " . $e->getMessage());
        header("Location: ../user/index.php?notif=3&error=" . urlencode($e->getMessage()));
        exit();
    }
}

// Jika tidak ada submit form, kembali ke halaman index
header("Location: ../user/index.php");
exit();
?>

