<?php
require_once('session.php');

// Validasi input parameter
if (!isset($_GET['cuid']) || empty($_GET['cuid'])) {
    die("Invalid Request");
}

$id = $_GET['cuid'];

// Gunakan prepared statement untuk mencegah SQL Injection
$stmt = $conn->prepare("SELECT * FROM `tb_transaksi` WHERE cuid = ?");
$stmt->bind_param("s", $id);
$stmt->execute();
$result = $stmt->get_result();
$s1 = $result->fetch_assoc();

if (!$s1) {
    die("Transaction not found");
}

$usersID = $s1['userID'];
$amounts = $s1['total'];

if ($s1['status'] == 0) {
    // Ambil data user
    $stmt_user = $conn->prepare("SELECT * FROM tb_user WHERE cuid = ?");
    $stmt_user->bind_param("s", $usersID);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    $data_usernya = $result_user->fetch_assoc();

    if (!$data_usernya) {
        die("User not found");
    }

    $username = $data_usernya['extplayer'];

    // Call fungsi transaksi
    $pw = $WL->transaksi($username, 'deposit', $amounts);
    if ($pw['status'] == 'success') {
        // Update status transaksi
        $stmt_update = $conn->prepare("UPDATE `tb_transaksi` SET `status` = 1 WHERE `cuid` = ?");
        $stmt_update->bind_param("s", $id);
        $stmt_update->execute();

        if ($stmt_update->affected_rows > 0) {
            header('Location: ../topup/');
            exit;
        } else {
            die("Failed to update transaction status");
        }
    } else {
        header('Location: ../request_depo/');
        exit;
    }
} else {
    header('Location: ../topup/');
    exit;
}
?>
