<?php
ob_start();
session_start();
include('../config/koneksi.php');

// Membaca data dari tb_seo
$cuid = 1;
$sql_0 = $conn->prepare("SELECT * FROM `tb_seo` WHERE cuid = ?");
$sql_0->bind_param("i", $cuid);
$sql_0->execute();
$result_0 = $sql_0->get_result();
$s0 = $result_0->fetch_array();
$urlweb = $s0['urlweb'];

// Token session
$token = session_id();

// Validasi dan sanitasi input pengguna
$full_name = filter_var($_POST['full_name'], FILTER_SANITIZE_STRING);
$usere = strtolower(trim($_POST['user']));
$user = str_replace(' ', '', filter_var($usere, FILTER_SANITIZE_STRING));
$randomNumber = rand(1, 10000);
$extplayer = $randomNumber . $usere;
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
$no_hp = filter_var($_POST['no_hp'], FILTER_SANITIZE_NUMBER_INT);
$akun = filter_var($_POST['akun'], FILTER_SANITIZE_STRING);
$no_rek = filter_var($_POST['no_rek'], FILTER_SANITIZE_NUMBER_INT);
$pass = password_hash($_POST['pass'], PASSWORD_DEFAULT);
$level = 'user';
$join_date = date('Y-m-d H:i:s');

// Cek jika username, email, no_hp, atau rekening sudah digunakan
$stmt_user = $conn->prepare("SELECT * FROM `tb_user` WHERE user = ?");
$stmt_user->bind_param("s", $user);
$stmt_user->execute();
$result_user = $stmt_user->get_result();
$q = $result_user->num_rows;

if ($q > 0) {
    header('location:../?notif=2'); // Username sudah digunakan
} else {
    $stmt_email = $conn->prepare("SELECT * FROM `tb_user` WHERE email = ?");
    $stmt_email->bind_param("s", $email);
    $stmt_email->execute();
    $qq = $stmt_email->get_result()->num_rows;

    if ($qq > 0) {
        header('location:../?notif=3'); // Email sudah digunakan
    } else {
        $stmt_hp = $conn->prepare("SELECT * FROM `tb_user` WHERE no_hp = ?");
        $stmt_hp->bind_param("s", $no_hp);
        $stmt_hp->execute();
        $qqq = $stmt_hp->get_result()->num_rows;

        if ($qqq > 0) {
            header('location:../?notif=4'); // Nomor HP sudah digunakan
        } else {
            $stmt_rek = $conn->prepare("SELECT * FROM `tb_bank` WHERE no_rek = ?");
            $stmt_rek->bind_param("s", $no_rek);
            $stmt_rek->execute();
            $qqqq = $stmt_rek->get_result()->num_rows;

            if ($qqqq > 0) {
                header('location:../?notif=5'); // No rekening sudah digunakan
            } else {
                // Sponsor/upline handling
                if (empty($_POST['sponsor'])) {
                    $uplineID = 1;
                } else {
                    $upline = $_POST['sponsor'];
                    $stmt_upline = $conn->prepare("SELECT * FROM `tb_user` WHERE user = ?");
                    $stmt_upline->bind_param("s", $upline);
                    $stmt_upline->execute();
                    $cu = $stmt_upline->get_result()->num_rows;

                    if ($cu == 0) {
                        $uplineID = 1;
                    } else {
                        $cuu = $stmt_upline->get_result()->fetch_array();
                        $uplineID = $cuu['cuid'];
                    }
                }

                // Call API create member (perlu dipastikan handling API benar)
                $response = $WL->CreateMember($extplayer);

                // Insert data user baru ke dalam database
                $stmt_insert_user = $conn->prepare("INSERT INTO `tb_user` (`userid`, `extplayer`, `user`, `pass`, `token_id`, `image`, `full_name`, `email`, `no_hp`, `level`, `pinTrx`, `reff`, `uplineID`, `join_date`, `last_login`, `status`, `statusGame`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $userid = 0; $token_id = 0; $image = 'avatar5.png'; $pinTrx = ''; $reff = 0; $last_login = $join_date; $status = 1; $statusGame = 0;
                $stmt_insert_user->bind_param("sssssssssssssssss", $userid, $extplayer, $user, $pass, $token_id, $image, $full_name, $email, $no_hp, $level, $pinTrx, $reff, $uplineID, $join_date, $last_login, $status, $statusGame);
                $stmt_insert_user->execute();
                $last_id = $conn->insert_id;

                // Insert balance user baru
                $stmt_insert_balance = $conn->prepare("INSERT INTO `tb_balance` (`userID`, `active`, `pending`, `transfer`, `payout`, `created_date`) VALUES (?, ?, ?, ?, ?, ?)");
                $active = 0; $pending = 0; $transfer = 0; $payout = 0;
                $stmt_insert_balance->bind_param("ssssss", $last_id, $active, $pending, $transfer, $payout, $join_date);
                $stmt_insert_balance->execute();

                // Insert bank user baru
                $stmt_insert_bank = $conn->prepare("INSERT INTO `tb_bank` (`image`, `akun`, `pemilik`, `no_rek`, `status`, `userID`) VALUES (?, ?, ?, ?, ?, ?)");
                $image_bank = ''; $status_bank = 1;
                $stmt_insert_bank->bind_param("ssssss", $image_bank, $akun, $full_name, $no_rek, $status_bank, $last_id);
                $stmt_insert_bank->execute();

                // Update jumlah referensi user
                $stmt_update_reff = $conn->prepare("UPDATE `tb_user` SET reff = reff + 1 WHERE cuid = ?");
                $stmt_update_reff->bind_param("i", $uplineID);
                $stmt_update_reff->execute();

                // Redirect ke halaman dengan notifikasi sukses
                header('location:../?notif=4');
                exit();
            }
        }
    }
}
?>
